﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "请注意，在产品激活期间收集的所有数据根据 Autodesk 的要求进行使用 ";
var xmsgOfflinePrivacyWarning= "如果您未连接到 Internet，要查看隐私保护政策，请将您的 Internet Explorer (R) 浏览器编码设置为“自动选择”。如果您可以访问 Internet，则也可以从 autodesk.com 联机访问隐私保护政策。"
////////////////////////////////////////////////////

var xmsgProductLanguage=	"zh-cn";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"授权已确认";
var xmsgRTActLicFound=                  "激活的许可已找到";
var xmsgRTActLicFoundError=            "注册-激活错误"; 
var xmsgRTAuthEntryError=				"激活输入错误";
var xmsgRTAuthError=					"激活错误";
var xmsgRTAuthNow=						"立即授权";
var xmsgRTBeginReg=						"开始注册";
var xmsgRTBuyInformation=				"购买信息";
var xmsgRTConfirm=						"用户确认";
var xmsgRTConnect=						"连接";
var xmsgRTConnectFail=					"连接错误";
var xmsgRTContactAutodesk=				"与 Autodesk 联系";
var xmsgRTCountryPage=					"国家/地区";
var xmsgRTEmail=						"电子邮件";
var xmsgRTFaxUS=						"用户传真给我们";
var xmsgRTMailUS=						"用户邮寄给我们";
var xmsgRTPurchaseOffline=				"脱机购买";
var xmsgRTRegConfirmed=					"注册已确认";
var xmsgRTExportConfirm=                "许可输出确认";
var xmsgRTImportConfirm=                "许可输入确认"; 
var xmsgRTRegVol=						"注册产品";
var xmsgRTSUNDataConfirm=				"SUN 数据确认";
var xmsgRTSUNServer=					"SUN 服务器";
var xmsgRTSUNSubmit=					"用户确认/提交 SUN";
var xmsgRTUserInfo=						"用户信息";
var xmsgRTLicFileSaveError=				"Flexlm 许可文件保存出错";
var xmsgRTProductInfo=                   "产品信息"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"获取网络许可";
var xmsgNSARTLocateLicense=				"定位许可文件";
var xmsgNSARTEditServerAndSeat=			"输入或修改服务器信息";
var xmsgNSARTConfirmServerAndSeat=		"确认服务器信息";
var xmsgNSARTEnterSN=					"输入序列号";
var xmsgProcessingError=				"处理错误";
var xmsgTimeout=        				"该任务已超时";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"激活:";
var xmsgPurchase=       "购买:";
var xmsgRegistrationFor=       "注册:";
var xmsgProduct=	"产品: ";
var xmsgsernum=		"序列号: ";
var xmsgsernumWGID=	"序列号或编组 ID: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "产品密钥: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"以前的序列号: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"以前的序列号:*";
var xmsgNewSernum1=	"输入序列号或编组 ID:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"申请号: ";
var xmsgRegAuthCode=	"激活码: ";
var xmsgApplicationKey=	"授权申请号: ";
var xmsgRTHostID=				"主机 ID:";
var xmsgRTFlexlmLicenseFile=	"许可文件:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"称呼:";
var xmsgNone=		"(无)";
var xmsgNotEntered=	"(未输入)";
var xmsgFirstname=	"名字:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"名字 (日语汉字):";
var xmsgFirstnameFurigana=	"名字 (全角日语片假名):";
var xmsgLastname=	"姓氏:";
var xmsgLastnameKanji=	"姓氏 (日语汉字):";
var xmsgLastnameFurigana=	"姓氏 (全角日语片假名):";
var xmsgCompanyName=	"公司名称:*";
var xmsgCompanyName2=	"公司名称:";
var xmsgCompanyNameJP=	"公司名称 (日语汉字): ";
var xmsgPhone=		"电话: ";
var xmsgArea=		"地区:";
var xmsgNumber=		"编号:";
var xmsgExt=		"扩展:";
var xmsgFax=		"传真:";
var xmsgFaxTo=		"传真至";
var xmsgEmail=		"电子邮件:";
var xmsgEmailTo=	"发送电子邮件至";
var xmsgAddress=	"街道地址:";
var xmsgAddress2=	"街道地址 2:";
var xmsgAddress3=	"街道地址 3:";
var xmsgJPAddress=	"镇:";
var xmsgJPAddress2=	"街道地址:";
var xmsgJPAddress3=	"建筑名称 (及房间号):";
var xmsgCity=		"城市:";
var xmsgSRP=		"州/地区/省:";
var xmsgStText=		"州:";
var xmsgPrText=		"省:";
var xmsgRegText=	"地区:";
var xmsgPrefectureText=	"区: ";
var xmsgCountyText=	"县: ";
var xmsgCantonText=	"乡: ";
var xmsgZipCode=	"邮政编码:";
var xmsgPostCode=	"邮政编码:";
var xmsgCountry=	"国家或地区:";
var xmsgDealer=		"Autodesk 授权经销商名称: ";
var xmsgMailTo=		"邮寄至";
var xmsgAnEmail=	"电子邮件地址";
var xmsgAFax=		"传真号码";
var xmsgAMailAddress=	"邮寄地址";
var xmsgPostalMail=		"邮件";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< 上一步";
var xmsgCancel=			"关闭";
var xmsgNext=			"下一步 >>";
var xmsgPrint=			"打印";
var xmsgPrintForm=		"打开激活申请表";
var xmsgNo=				"否";
var xmsgYes=			"是";
var xmsgBrowse=			"浏览";
var xmsgDone=			"完成";
var xmsgOK=				"确定";
var xmsgClose=			"关闭";
var xmsgSubmit=			"提交";
var xmsgFinish=			"完成";
var xmsgReset=			"全部清除";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"请选择 ";
var xmsgPleaseSelect2=		"选择以下的某个选项，然后单击“下一步”。";
var xmsgSelectCountry=		"产品使用者所在的国家/地区: ";
var xmsgSelectCountry2=		"国家和地区:";
var xmsgInformation=		"信息";
var xmsgCompanyInfo=		"公司信息:";
var xmsgContactInfo=		"联系信息:";
var xmsgResponseMethodInfo=	"响应方式信息:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"表格提交方式:";
var xmsgConfirmInfo=		"确认信息";
var xmsgConfirmInfoTxt=		"查看下列信息。  单击表格提交方式链接之一以继续 (使用显示的信息)，或单击“上一步”进行更改。";
var xmsgConfirmCustIDInfoTxt=		"确认以下信息。单击“下一步”继续，或者单击“上一步”进行修改。";
var xmsgCountryHdr=			"产品注册";
var xmsgCountryRegTo=		"本产品将注册给： ";
var xmsgCountryComp=		"公司";
var xmsgCountryIndiv=		"个人";
var xmsgCountryUpgrade=		"这是升级版";
var xmsgCountryUpgDetail=	"(如果您是速博应用(Subscription)客户，请单击“否”。)";
var xmsgConnectHdr1=		"正在连接";
var xmsgConnectHdr=		"连接到 Internet";
var xmsgConnectMsg=		"连接";
var xmsgConnectTxt=		"未检测到 Internet 连接。要提交联机请求，请现在就连接到 Internet。";
var xmsgConnectTxtOLT=    "未检测到 Internet 连接。要传输许可，请现在连接到 Internet。";
var xmsgConnectTxt2=	"建立 Internet 连接后，单击“下一步”。";
var xmsgConnectTxt3=	"要使用其他方式提交请求，请单击以下链接: ";
var xmsgConnectWarming=	"提交此信息可能需要几分钟时间。请稍候。";
var xmsgTryAgain=		"重试";
var xmsgReEnterOld=		"重新输入先前的序列号";
var xmsgNewSernum3=		"请输入新序列号并单击“下一步”。";
var xmsgNewSernum4=		"试用版软件安装时使用了序列号 (000-00000000)，此序列号无法注册。如果您已经购买了本软件，您就已经获得了一个新序列号。必须使用这个序列号进行激活，使产品可以投入使用。";
var xmsgNewSernum5=		"输入序列号或编组 ID:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "请输入产品密钥:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"确认新序列号: ";
var xmsgNewSernum8=		"重输入新序列号";
var xmsgUseOtherMethod=		"使用另一种注册方法";
var xmsgContactAutodesk=	"与 Autodesk 联系";
var xmsgContactAutodeskLink="要与 Autodesk 联系，请单击以下链接: ";
var xmsgContactOptions=		"联络方式显示如下:";

var xmsgPuchaseInfo1=		"购买信息";
var xmsgPuchaseInfo2=		"您已选择进行联机购买。"; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"单击“下一步”继续；如果不需要继续，可单击“取消”。"; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"注册 - 激活";
var xmsgRegTitleBuy=		"联机购买 Autodesk 产品";
var xmsgRegTitleNSA=		"网络许可激活";
var xmsgRegInfo=		"客户信息";
var xmsgRegInfo2=		"注册方法";
var xmsgRegInfo3=		"请选择一种注册方法并单击“下一步”。";
var xmsgRegmethod1=		"通过 Internet 直接连接";
var xmsgRegmethod3=		"我希望通过以下方式收到激活码: ";
var xmsgRegmethod5=		"邮件";
var xmsgRegmethod6=		"单击下面的“打印”，并将此表格邮寄给:";
var xmsgRegmethod7=		"传真";
var xmsgRegmethod8=		"要打印可以传真给 Autodesk (传真号码 %1) 的表单，请首先选择接收激活码的方式，单击“打印”，然后传真该表单。";
var xmsgRegmethod9=		"电子邮件";
var xmsgRegmethod10NSA=		"下面显示的注册和许可服务器信息已自动保存到文件中。";
var xmsgRegmethod10=		"注册信息已保存到以下文件中，该文件将用于完成电子邮件注册的过程 (请勿修改此文件): ";
var xmsgRegmethod11NSA=		"通过电子邮件将注册和许可服务器信息文件 %1 发送到 %2。";
var xmsgRegmethod11=		"通过电子邮件将注册信息文件 %1 发送到 %2。";
var xmsgRegmethod12=		"确保您对该文件未作任何修改。<p>建议您将本页打印一份，然后存放到安全的地方。手动完成电子邮件过程时，将用到这些信息。<p>您可以将这些信息打印一份以作记录。单击“完成”关闭本应用程序。";
var xmsgRegmethod13=		"要自动附着 %1 并将其发送至 Autodesk，请单击以下链接。";
var xmsgRegmethod14=		"通过电子邮件发送申请";
var xmsgRegmethod15=		"注意: 这是自动进行回复的电子邮件地址。请勿与此地址进行电子邮件通信。";
var xmsgRegmethod16=		"要通过传真或邮件注册，请单击以下链接之一:";
var xmsgRegmethod17=		"发送电子邮件时出错";
var xmsgRegmethod18NSA=		"在系统尝试自动发送注册和许可服务器信息时出错。";
var xmsgRegmethod18=		"在系统尝试自动发送注册信息时出错。";
var xmsgRegmethod19=		"要手动通过电子邮件发送该文件:";
var xmsgRegmethod20NSA=		"通过电子邮件将注册和许可服务器信息文件 %1 发送到 %2。";
var xmsgRegmethod20=		"通过电子邮件将注册信息文件 %1 发送到 %2。";
var xmsgRegmethod21=		"确保您对该文件未作任何修改。<p>建议您将本页打印一份，然后存放到安全的地方。手动完成电子邮件过程时，将用到这些信息。<p>您可以将这些信息打印一份以作记录。单击“完成”关闭本应用程序。";
var xmsgRegAuthInfo=		"激活";
var xmsgRegAuthInfo1=		"注册确认";
var xmsgRegExpConfirm=      "许可输出确认";
var xmsgRegImpConfirm=      "许可输入确认";
var xmsgRegAuthInfo2=		"获取激活码";
var xmsgRegAuthInfo3=		"输入激活码"; 
var xmsgRegAuthInfo4=		"选择以下一个选项:";
var xmsgRegAuthInfo4A=		"输入激活码";
var xmsgRegAuthInfo4B=		"输入激活码: "; 
var xmsgRegAuthInfo5=		"请选择国家或地区，输入激活码并单击“下一步”。";
var xmsgRegAuthInfo6=		"注册 - 激活确认";	
var xmsgRegAuthInfo7=		"感谢您注册并激活产品。";
var xmsgRegAuthInfo8=		"确认";		
var xmsgRegAuthInfo9=		"感谢您注册 Autodesk 产品。这将帮助我们为您提供更好的服务。";
var xmsgRegAuthInfo10=		"一份注册信息已保存到:";		
var xmsgRegAuthInfo10B=		"一份注册信息已保存到:";
var xmsgRegActLicInfo=      "激活的许可已找到";
var xmsgRegActLicInfoError=      "注册-激活错误";
var xmsgRegActiveInfo=        "键入或浏览至激活文件:";
var xmsgRegActLicInfo1=       "在该计算机上找到了针对您产品的先前已注册并激活的许可。谢谢您。"
var xmsgRegActLicInfo1Error= "在该计算机上找到了针对您产品的先前已注册并激活的许可。\n 但出现意外错误 (%1)。请关闭该应用程序并重试。如果该问题继续出现，请联系您的系统管理员或 Autodesk 产品授权代理商";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "输出成功"; //2008-01-16
var xmsgExportFail=           "输出请求失败" ; //2008-01-16
var xmsgRegErrRef=            "错误参照:"; //2008-01-17
var xmsgImportSuccess=        "输入成功"; //2008-01-16
var xmsgImportFail=           "输入请求失败"; //2008-01-16
var xmsgExpSucessInfo=        "您的许可已成功输出，现位于 Autodesk 服务器上。"; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "如何输入许可";
var xmsgExpSucessInfo1=        "在目标计算机上启动产品之前，请使用许可传输实用程序将该许可输入该计算机，然后准备输入 Autodesk 用户 ID 和密码。";  //2008-01-16
var xmsgImpSucessInfo=         "许可已成功输入；您现在可以使用本产品。 "; //2008-01-16
var xmsgImpRemindInfo=         "提醒我输出。"; //2008-01-16
var xmsgImpRemindInfo1=        "如果勾选该复选框，则每次退出时，都会显示提醒您输出许可的对话框。";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "如果您要暂时将许可输入该计算机且需要将其传输回去时，该功能会很有用。";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "提醒中有一个“不再显示此消息” 选项。";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "单击 \"重试\" 链接可重新提交请求。 ";
var xmsgImpFailMsg=            "如果问题仍然存在，应激活许可，而不是将其输入。";

var xmsgReqfilelocMsg=       "请求文件位于:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"感谢您的注册 - 您的产品现在已激活，并且许可文件已保存。请单击“打印”以保留此信息的记录。";
var xmsgRegAuthInfo12=		"粘贴激活码。";
var xmsgRegAuthInfo13=		"键入激活码。";
var xmsgRegErrorActiveCode=    "<FONT color=red>输入激活码继续。</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>激活码无效。请检查代码是否出错。</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>输入激活文件路径和名称以继续。</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>请输入序列号以继续。</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>序列号太短。</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>输入产品密钥以继续。</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>产品密钥太短。</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"注册 - 激活错误";
var xmsgRegErrorSystem=		"出现临时的系统问题，导致注册过程出错。请单击以下链接之一。"
var xmsgRegErrorPrevReg=	"您输入的序列号已经注册。";
var xmsgRegErrorMaxAuth=	"您已经超出了本产品所允许的激活数目。";
var xmsgRegErrorMaxAuth2=	"您已经超出了本产品所允许的许可数目。";
var xmsgRegErrorInvalidOld=	"您输入的早期产品的序列号无效。请验证上面显示的早期序列号是否正确，然后单击以下链接之一。";
var xmsgRegErrorData=		"您提供的注册数据有问题。您可以选择“重试”以查看并更正所输入的信息，使用其他方法进行注册，也可与 Autodesk 联络以便继续。";
var xmsgRegErrorNetwork=	"您尝试注册的产品是网络授权的产品，必须以网络方式进行安装。您必须删除安装该软件，然后选择“网络”作为安装类型。<p>请参考安装手册中的“网络安装”一节，以了解安装和激活网络版的正确步骤。";
var xmsgRegNoResponse=		"出现临时问题，导致联机注册过程出错。请单击以下链接之一。";
var xmsgRegErrorAuthEntry=	"您输入的激活码有问题。请单击以下链接之一。";
var xmsgRegErrorAuthPermission = "要激活本 Autodesk 产品，您必须具有管理员权限或由系统管理员授予更高的权限。有关管理员和更高权限的详细信息，请与系统管理员联系。";							
var xmsgRegErrorAuth=		"激活码有问题。请单击以下链接之一。";
var xmsgRegErrorFlex=		"许可有问题。请单击以下链接之一。";
var xmsgRegConnError=		"连接错误";
var xmsgRegConnErrorTxt=	"Internet 连接有问题。请单击以下链接之一。";
var xmsgRegPurchError3=		"使用另一种购买方法";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "感谢您选择购买 Autodesk 软件。<p>用以完成此过程的连接目前不可用，这可能是由于系统设置的缘故。<p>在下面的任意一个链接上单击以打开浏览器，如此可能使您连接成功。<p>";

var xmsgAuthResellerMsg1=	"从本地经销商处购买。与本地经销商联系，以完成购买。";

var xmsgLicSaveErrInfo=		"保存许可文件时出现错误。请单击以下链接之一。";

var xmsgOnlineStoreMsg1=	"在 Autodesk 联机商店中购买。如果在商店中找不到要购买的产品，请与授权经销商联系。";
var xmsgOnlineStoreMsg2=    "联机商店";
var xmsgAuthResellerMsg2=	"授权经销商";
var xmsgLocateLicenseMsg1=	"定位许可文件";
var xmsgLocateLicenseMsg2=	"输入许可文件的路径 (或使用“浏览”定位一个许可证文件)，然后单击“下一步”继续。";
var xmsgLocateLicenseMsg3=	"现有许可文件:";
var xmsgUserContactMsg=		"至少必须输入以下内容之一: ";
var xmsgFailureMsg=		    "无法处理您的联机激活申请。";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "您的联机激活申请返回错误 (%1)，此错误不允许使用我们的自动系统处理您的申请。";
var xmsgRegErrorOnline=		"单击下面的“使用其他方式”链接以完成必要的表格，并将您的申请提交给当地的 Autodesk Business Center。 客户服务代表将在接下来的 2 个工作日内做出响应。";
var xmsgAnotherFormSubmitMethod=    "使用其他方式";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "您的联机激活申请已超时。"
var xmsgTimeoutMsg2=    "单击“重试”链接重新提交您的联机申请。如果问题仍然存在，您可以单击“使用其他方式”链接以完成必要的表格，并使用电子邮件、传真或其他选项提交您的申请。";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"注册数据已保存";
var xmsgRegSunData2=		"客户端展开所需的注册数据已经保存在 ";
var xmsgRegSunData3=		"为此升级版注册提供的“以前的序列号”无效。请与管理员联系。";
var xmsgRegSunData4=		"本软件必须以有效的以前的序列号重新安装。";
var xmsgRegSunData5=		"多套单机展开";
var xmsgRegSunData6=		"要完成多套单机展开，需要某些注册信息。随后的对话框将:";
var xmsgRegSunData7=		"收集必要的信息。";
var xmsgRegSunData8=		"如果升级时需要，可以输入以前的序列号。";
var xmsgRegSunData9=		"在服务器上存储此信息，以便展开到所有的客户端安装。";
var xmsgRegSunData10=		"此软件将用以下信息注册。单击“下一步”继续。";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"产品注册";
var xmsgRegVol2=	"选择选项然后单击“下一步”:";
var xmsgRegVol3=	"现在注册 - 选择此选项开始联机注册";
var xmsgRegVol4=	"以后注册 - 选择此选项试用此软件";
var xmsgRegVol5=	"不再显示此消息。";
var xmsgRegVol6=	"(如果希望以后再注册，可以在“帮助”-“关于”对话框中选择注册选项。)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"客户标识符";
var xmsgKatakana=		    "公司名称 (全角日语片假名):";
var xmsgDepartment=		    "部门: ";
var xmsgDepartment2=		"部门名称:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"在 Internet 上: ";
var xmsgFormWebDataMsg1= "您还可以通过访问以下网址获取激活码:<br>";
var xmsgFormEmailHdr=	"电子邮件:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"传真:";
var xmsgFormFaxHdrLocal=	"传真至本地办事处:";
var xmsgFormFaxHdrReg=	"传真注册:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"电话: ";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"邮件:";
var xmsgFormMailHdrLocal=	"邮寄至本地办事处:";
var xmsgFormMailHdrReg=	"邮件注册:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"购买软件";
var xmsgFormInternetMsg=    "要使用 Web 浏览器申请激活码，请单击此链接。"
var xmsgFormEmailMsg=       "通过电子邮件将信件和激活申请发送至:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Autodesk 将使用您提供的信息来注册和/或发放激活码。进行注册即表明您同意 Autodesk 将您的相关信息提供给我们的授权商业合作伙伴，用于产品许可管理和权利验证。如果您希望 Autodesk 不要将您的相关信息与授权商业合作伙伴共享，以用于这些有限的目的，请通过 <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> 与 Autodesk 联系。如果您希望更正或更新注册数据，请单击<a %1>此处</a>与 Autodesk 联系，或者与当地的 Autodesk 办事处联系。";
			
var privacystatement = "Autodesk 将使用所提供的信息来注册和/或发放激活码、帮助您了解关于我们的产品和服务的最新信息，以及确保您从 Autodesk 授权用户的身份中受益。Autodesk 不会将您的信息出售或者提供给 Autodesk 或我们的授权商业合作伙伴之外的任何人。如果要更正或更新早期注册的客户信息，请单击<a %1>此处</a>，与 Autodesk 或当地的 Autodesk 办事处联系。";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="隐私保护政策";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) 版权所有 2009 Autodesk, Inc.保留所有权利。"; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="在大多数情况下，新序列号将在您关闭程序并使用管理员权限重新启动程序之后显示。";
var xmsgRebranding2="关于如何使用管理员权限启动程序的信息，请参阅操作系统说明文件。";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "标记为 <FONT color=red>*</FONT> 的字段是必需的字段。";
var xmsgRegInfoMsg2= "本页上输入的信息将与许可存储在一起。此信息用于产品的重新激活和升级。请确保在此处输入有效的信息，以避免在使用产品时出现延迟。";

var xmsgLicLocationText1 = "将 <b>%1</b> 的许可文件保存到:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"问题: ";

var xmsgAppUsageQ1=	"为了帮助 Autodesk 更好地了解您所在行业的需求，请回答以下问题。";
var xmsgAppUsageQ2=	"以下哪一项最好地描述了您所从事的主要领域？";

var xmsgAppUsageOption51=	"航空和汽车零部件设计 ";
var xmsgAppUsageOption52=	"建筑设计 ";
var xmsgAppUsageOption53=	"建筑和设备管理 ";
var xmsgAppUsageOption54=	"建筑施工: 商务 ";
var xmsgAppUsageOption55=	"建筑施工: 住宅 ";
var xmsgAppUsageOption56=	"建筑设备制造 ";
var xmsgAppUsageOption57=	"土木工程/土地规划 ";
var xmsgAppUsageOption58=	"计算机/医药/办公设备设计 ";
var xmsgAppUsageOption67=	"消费产品设计 ";
var xmsgAppUsageOption59=	"企业建筑所有权 ";
var xmsgAppUsageOption92=	"防御 ";
var xmsgAppUsageOption93=	"电气控制设计 ";
var xmsgAppUsageOption94=	"电气系统工程 ";
var xmsgAppUsageOption72=	"环境工程 ";
var xmsgAppUsageOption95=	"金属制品制造业 ";
var xmsgAppUsageOption96=	"室内设计 ";
var xmsgAppUsageOption97=	"机械设计 ";
var xmsgAppUsageOption98=	"生产采购/销售/市场 ";
var xmsgAppUsageOption40=	"制图与地理空间设计 ";
var xmsgAppUsageOption41=	"机械系统工程 (HVAC 和管道) ";
var xmsgAppUsageOption42=	"管路和/或消防系统工程 ";
var xmsgAppUsageOption43=	"工序和电力设备设计 ";
var xmsgAppUsageOption44=	"房地产开发 ";
var xmsgAppUsageOption45=	"结构工程 ";
var xmsgAppUsageOption87=	"电信 ";
var xmsgAppUsageOption46=	"工具和模具/机械车间 ";
var xmsgAppUsageOption47=	"运输设计 ";
var xmsgAppUsageOption48=	"公共设施: 电、石油和煤气 ";
var xmsgAppUsageOption49=	"公共设施: 水和下水道 ";
var xmsgAppUsageOption99=	"其他 ";

var xmsgWrongCountryCodeMsg=	"错误: 未输入已知的国家/地区代码！";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "版本:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"我将通过传真或电话发送申请"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"通过邮寄进行注册。";
var xmsgAccessHereMsg=		"此处。";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "我希望通过以下方式获得代码:";
var xmsgReceiveCodeMsg1=     "我希望通过电子邮件接收我的激活文件"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"正在验证您的许可，<br>请稍候";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "产品信息"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "所有字段均为必填字段。"; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"获取网络许可";
var xmsgNSARTBeginMsg1=		"通过以下方式申请网络许可激活文件:";
var xmsgNSARTBeginMsg2=		"直接连接 (通过 Internet)";
var xmsgNSARTBeginMsg3=		"通过电子邮件、传真或电话发送申请";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"服务器信息";
var xmsgEditServerHdrMsg2=	"许可服务器模式*";
var xmsgEditServerMsg1=		"输入许可服务器信息。<br>单击“查寻”按钮以自动填写“服务器主机 ID”字段。<p>";
var xmsgEditServerMsg2=		"从现有的许可文件获取服务器主机数据。";
var xmsgEditServerRemove=	"删除";
var xmsgEditServerHostName=	"服务器主机名*";
var xmsgEditServerHostID=	"主机 ID*";
var xmsgEditServerSeat=		"套数*";
var xmsgEditServerSingle=	"单一服务器";
var xmsgEditServerDistributed=	"分布式服务器";
var xmsgEditServerRedundant=	"冗余服务器";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"查寻";
var xmsgEditServerAddServer=	"添加";
var xmsgEditServerRemoveServer=	"删除";
var xmsgEditServerTotal=	"总共:";
var xmsgEditServerExceedMaxServer=	"注意: 一次最多可以授权 20 台分布式服务器。如果您需要授权的服务器超过 20 台，请与 Autodesk 联系。";
var xmsgEditServerSeatError=	"“套数”中只能包含数字值。";

var xmsgConfirmServerMsg=	"检查以下信息。单击“下一步”继续，或者单击“上一步”进行修改。";
var xmsgConfirmServerMsg2=	"单击“下一步”后，这些信息将通过 Internet 发送给 Autodesk。";
var xmsgConfirmServerHdr2=	"许可服务器模式:";
var xmsgConfirmServerHostName=	"服务器主机名";
var xmsgConfirmServerHostID=	"主机 ID";
var xmsgConfirmServerSeat=		"套数";
var xmsgConfirmServerTotal=		"总套数:";

var xmsgLicErrorHdr=			"授权错误"; 
var xmsgLicErrorInvalidSN=		"您输入的序列号无效。请验证上面显示的序列号是否正确，然后单击以下链接之一。";
var xmsgLicReEnterSN=			"重新输入序列号并重试。";

var xmsgLic113Msg2=				"您为分布式服务器分配的总套数超过了此数目。";
var xmsgLic113ModifySeats=		"修改套数分布。";

var xmsgSaveLicenseHdr=			"已收到许可";
var xmsgSaveLicenseMsg1=		"您已从 Autodesk 收到许可。必须现在就将它们保存到许可文件中。<p> <b>将许可保存到许可文件中</b><p><LI><b>建议</b>将许可文件保存在服务器上 Autodesk Network License Manager 安装目录的“License”子目录中。";
var xmsgSaveLicenseMsg6=		"<LI>如果您已经拥有<b>许可文件</b>，可将新的许可<b>插入</b>到其中。<br>单击“下一步”后，系统将自动把许可信息插入到现有文件中的适当位置。</LI>";
var xmsgSaveLicenseMsg2=		"如果上面指定的文件是现有的许可文件:";
var xmsgSaveLicenseMsg3=		"将新的许可信息插入到其中。";
var xmsgSaveLicenseMsg4=		"覆盖现有的许可文件。";
var xmsgSaveLicenseMsg5=		"请更正以下错误:";

var xmsgSaveErrorFileNameTooLong=  "错误: 您输入的文件名过长。<br>" +
								"请更改文件名并继续。";
var xmsgSaveErrorNoPermission=	"错误: 没有足够的权限将文件保存到指定的位置。<br>可以将该文件保存到临时位置，获取适当的权限，然后再移动文件。";
var xmsgSaveErrorNoDiskSpace=	"错误: 没有足够的磁盘空间将文件保存到指定的位置。<br>可以将该文件保存到临时位置，准备足够的空间，然后再移动文件。";
var xmsgSaveErrorInvalidFile=	"错误: 新的许可无法在不丢失数据的前提下附加到指定的文件。指定的文件可能是用于不同的计算机或服务器模式的。<BR>可以用不同的文件名保存新的许可文件，或者将其保存在不同的位置，以后再手动将其附加到该文件。";															
var xmsgSaveErrorPathNotExit=	"错误: 指定的路径不存在。<BR>请单击“浏览”按钮查找或创建该路径。";
var xmsgSaveErrorPathBlank=		"错误: 必须指定有效的路径和许可文件名。请在下面的字段中指定路径和文件名，或者单击“浏览”以查找某个路径和文件名。";

var xmsgLicAuthConfirmHdr1=		"许可证激活成功！";
var xmsgLicAuthConfirmHdr2=		"许可服务器主机信息";
var xmsgLicAuthConfirmMsg1=		"感谢您注册产品。您可以打印此信息作为记录。";
var xmsgLicAuthConfirmDate=		"日期:";

var xmsgLicPathMsg1=			"已保存以下许可文件:";
var xmsgLicPathMsg2=			"您的许可文件已保存到:";

var xmsgOtherMethodMsg1NSA=		"通过其他方式获取授权的许可。";
var xmsgOtherMethodMsg1=		"使用其他方法。";

var xmsgContactAutodeskMsg1=	"请使用以下方法之一与 Autodesk 联系。";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"通过电子邮件获取许可文件";
var xmsgEmailOptionTitle=		"通过电子邮件进行注册";
var xmsgEmailOptionNSAMsg=		"您的注册和许可服务器信息已自动保存为文件。必须通过电子邮件将该文件发送到 Autodesk 的自动注册处理中心。<p>在您通过电子邮件将该文件成功发送到 Autodesk 之后，您将收到自动响应、已授权的许可文件以及有关如何完成注册过程的说明。";
var xmsgEmailOptionMsg=			"您的注册信息已自动保存为文件。必须通过电子邮件将该文件发送到 Autodesk 的自动注册处理中心。<p>在您通过电子邮件将该文件成功发送到 Autodesk 之后，您将收到自动响应以及有关如何完成注册过程的说明。";
var xmsgEmailOptionMsg2=		"如果您使用的默认电子邮件系统目前可以通过 Internet 发送电子邮件，请单击“立即发送文件”，然后单击“下一步”。该文件将会自动发送出去。<p>如果您现在不能发送电子邮件，请单击“以后再手动发送文件”。您将获得关于如何手动发送该文件的说明。";
var xmsgEmailOptionInfo1=		"立即发送文件。";
var xmsgEmailOptionInfo2=		"以后再手动发送文件。";
var xmsgEmailOptionInfo3=		"将电子邮件抄送到我提供的电子邮件地址。";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"无法生成电子邮件";
var xmsgEmailErrorMsg1=			"要通过电子邮件完成注册，请将以下文件附着到电子邮件中: ";
var xmsgEmailErrorMsg2=			"将电子邮件发送到 %1。";
var xmsgEmailErrorMsg3=			"该文件可以在以下位置中找到: ";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"修改客户信息";
var xmsgLocalHEREInfo=			"要修改客户信息，请与 Autodesk 授权代理商联系，或在下面浏览至适用于您所在国家或地区的链接。";
var xmsgLocalHEREUS=			"美洲";
var xmsgLocalHEREEMEA=			"欧洲、中东、非洲";
var xmsgLocalHEREAPAC=			"亚太地区";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"帮助";
var xmsgHelpUpgradeMsg=			"如果要注册或激活早期版本的升级版，则必须选中此框。将提示您输入要对其进行升级的那个版本的序列号。";
var xmsgHelpUpgradeRequiredTitle=	"输入早期产品的序列号 (升级所需)";
var xmsgHelpUpgradeRequiredMsg=	"这是早期版本软件的序列号。您可以在软件的“帮助”>“关于”对话框或早期产品的外包装上找到序列号。";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"尚未输入 %1。如果要通过此方式接收激活码，请输入。";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "序列号/编组 ID"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "您的序列号位于产品包装上，或“Autodesk 升级和许可信息”电子邮件中。"; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "产品密钥";
var xmsgHelpProductKeyMsg=    "您的产品密钥位于产品包装上的序列号旁边，或“Autodesk 升级和许可信息”电子邮件中。"; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"连接错误 (0.15)";
var xmsgRT010203071213CannotCompErrA=	"注册错误 (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"已注册 (9)";
var xmsgRT10ExceededAuths=				"超出授权数 (10)";
var xmsgRT12StolenSN=					"被盗的序列号 (12)";
var xmsgRT18OldSNInvalid=				"以前的序列号无效 (18)";
var xmsgRT20DataError=					"数据错误 (20)";
var xmsgRT21CustIDTelErr=				"客户 ID/电话错误 (21)";
var xmsgRT22NetworkInstallation=		"网络安装错误 (22)";
var xmsgRT900SystemNotResponding=		"系统未响应 (900)";
var xmsgRTCustID=						"客户 ID";
var xmsgRTCustIDConfirm=				"确定标识";
var xmsgRTNewSerialNumber=				"新序列号信息";
var xmsgRTNoNewSN=						"购买事务发生错误";
var xmsgRTPurchAuthFailed=				"激活错误";
var xmsgRTPurchConfirmOther=			"购买确认";
var xmsgRTPurchConfirmPerm=				"购买确认 - 已注册和激活";
var xmsgRTPurchConfirmReg=				"购买确认 - 已注册但未激活";
var xmsgRTPurchConfirmRegVol=			"购买确认 - 已注册";
var xmsgRTPurchConfirmRent=				"购买确认 - 已注册并激活租用";
var xmsgRTPurchConfirmUnReg=			"购买确认 - 未注册或激活";
var xmsgRTPurchConnectionFailed=		"购买连接失败";
var xmsgRTPurchaseError=				"购买错误";
var xmsgRTSNMismatch=					"购买事务出错 - 序列号不匹配";
var xmsgRTSUNOldSNInvalid=				"以前的序列号无效 - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"退出";

var xmsgCustIDMainTitle=	"客户标识符";
var xmsgCustIDTitle1=		"客户 ID:";
var xmsgCustIDText2=		"在下面输入您的客户 ID 和电话号码。如果您没有客户 ID，请将这两个字段保留空白。<p> ";
var xmsgCustIDText3=		"注意: 如果您要重新激活产品，则必须输入客户 ID。";
var xmsgCustIDText3NSA=		"注意: 如果您要重新授权产品，则必须输入客户 ID。";
var xmsgCustIDTitle2=		"电话号码:";
var xmsgCustIDTelEx4=		"(例如: 03-111-1234)";
var xmsgRegCustIDTel=		"您输入的“客户 ID”和“电话号码”与我们的记录不匹配。请单击以下链接之一。";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"我们的记录表明您可以使用 %1 套有效的 %2。<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"输入的序列号无效";
var xmsgErr12APAC=				"<p>这是无效的序列号，无法激活。请通过以下电子邮件地址与我们联系: <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>尊敬的先生/女士</p>" +
								"<p>感谢您尝试向 Autodesk 注册 Autodesk(R) 或 Discreet(TM) 软件产品。</p>" +
								"<p>但是，我们的记录表明，您尝试向我们注册的 Autodesk(R) 或 Discreet(TM) "+
								"软件产品的序列号不是有效的序列号，或该序列号"+
								"是该软件产品的已知盗版版本的序列号。因此，您使用的 Autodesk(R) 或 " +
								"Discreet(TM) 软件产品未被授权。</p>" +
								"<p>可从 Autodesk 授权代理商处购买 Autodesk(R) 软件产品的" +
								"使用许可 - 请访问 " +
								"<a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> " +
								"获取您所在地区的 Autodesk 授权代理商清单或 " +
								"Autodesk 办事处。使用合法软件是确保" +
								"您能够从使用软件中获得最大利益，并免于" +
								"可能因非法使用和/或复制软件而提起的民事和刑事诉讼的唯一方式。</p>" +
								"<p>可从 Discreet 授权代理商处购买 Discreet(TM) 软件产品的" +
								"使用许可 - 请访问 " +
								"<a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> " +
								"以获取您所在地区的 Discreet 授权代理商或 " +
								"Discreet 办事处列表。使用合法软件是确保" +
								"您能够从使用软件中获得最大利益，并免于" +
								"可能因非法使用和/或复制软件而提起的民事和刑事诉讼的唯一方式。</p>" +
								"<p>因此，我们诚恳地请求您立即停止使用尝试向我们注册的未授权软件产品，" +
								"删除存储在任何计算机硬件上的所有副本，并" +
								"销毁包含该软件产品的任何介质。我们相信，您将自愿服从" +
								"我们的请求，但是，Autodesk 保留与此事件相关的权利，并可能将您的详细信息传送至" +
								"商业软件联盟 (“BSA”)。</p>" +
								"<p>如果您有任何疑问，或确信您错误地收到此消息，请通过以下电子邮件地址" +
								"与我们联系: " + //根据 Raptro 建议于 2007 年 9 月 3 日由 joyce.min 修改电子邮件地址
								"<a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p>" +
								"<p>如果您愿意提供有关使用或销售非法软件的信息，请" +
								"与您当地的 Autodesk 办事处联系，或通过访问以下地址与 BSA 联系: " +
								"<a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p>" +
								"<p>谢谢</p>";
var xmsgErr12US=				"<p>尊敬的先生/女士</p><p>您最近尝试向 Autodesk 或 Discreet 注册软件产品。</p><p>但是，我们的记录表明，您尝试向我们注册的 Autodesk(R) 或 Discreet(TM) 软件产品的序列号不是有效的序列号，或该序列号是该软件产品的已知盗版版本的序列号。因此，您使用的 Autodesk(R) 或 Discreet(TM) 软件产品未被授权。</p><p>对于 Autodesk 用户，可从 Autodesk 授权代理商处购买 Autodesk(R) 软件产品的使用许可。有关您所在地区的 Autodesk 授权代理商列表，请访问 <a href=\"http://www.autodesk.com.cn\" target=\"_blank\">http://www.autodesk.com.cn</a>。  使用合法软件是确保您能够从使用软件中获得最大利益，并免于可能因非法使用和/或复制软件而提起的民事和刑事诉讼的唯一方式。</p><p>对于 Discreet(TM) 用户，可从 Discreet 授权代理商处购买 Discreet(TM) 软件产品的使用许可。有关您所在地区的 Discreet 授权代理商或 Discreet 办事处列表，请访问 <a href=\"http://www.apac.discreet.com\" target=\"_blank\">www.apac.discreet.com</a>。使用合法软件是确保您能够从使用软件中获得最大利益，并免于可能因非法使用和/或复制软件而提起的民事和刑事诉讼的唯一方式。</p><p>您必须立即停止使用尝试向我们注册的未授权软件产品，删除存储在任何计算机硬件上的所有副本，并销毁包含该软件产品的任何介质。我们相信，您将自愿服从我们的请求，但是，Autodesk 保留与此事件相关的权利，并可能将您的详细信息传送至商业软件联盟 (BSA)。</p><p>如果您有任何疑问，或确信您错误地收到此消息，请通过以下电子邮件地址与我们联系: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>如果您愿意提供有关使用或销售非法软件的信息，请与您当地的办事处联系，或访问 <a href=\"http://www.BSA.org.cn\" target=\"_blank\">www.BSA.org.cn</a> 来与 BSA 联系</p><p>谢谢</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFAAEhrERw5LL
// SIG // /Yw8piiqSgwDX+dAoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFFceaC0Igt0O0/TvVWpfb2+Zce8gMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAc
// SIG // nDS3tv3vnRyjwJ0XllMgDpOJiTkvDJ17kWN03giWq8lH
// SIG // oyxP2yxiHbhH5t0udziz9NkTJJiuiBrETJzjRLHo1+hc
// SIG // 6TC5tZ7FkhWi00x7lA83eSsUpXxa40mme3f3YROsqrAN
// SIG // O29sfCDCyzRUkBTWpDAnpA0ABQQV6dR/xZVWAKGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMyOTI3
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUN7GOCbIDQ8wjc+h6OK+V
// SIG // 4rUYpgIwDQYJKoZIhvcNAQEBBQAEgYAFYCscncRt6yhf
// SIG // iocBdy0NdhwkrGN3/lCS1Jcl9mUbTiNJC59v82Yv+nwp
// SIG // DdN/9lJMiA7f1uHovJEsnmPZudLxKXf5Cfsqc9oOjPcG
// SIG // Iz9eirAP/WuYJh5oEaVwbhZEtooaoybYMzEU321IQZvD
// SIG // SxVWkd0GGP1i8anZtgkKlwndgA==
// SIG // End signature block
